<?php
/**
 * Online Players
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\OnlinePlayers;

// plugin root
define('__PATH_ONLINEPLAYERS_ROOT__', __PATH_PLUGINS__.'onlineplayers/');

// plugin root
define('__ONLINEPLAYERS_HOME__', __BASE_URL__.'onlineplayers/');

// admincp
$extra_admincp_sidebar[] = array(
    'Online Players', array(
        array('Settings','onlineplayers&page=settings')
    )
);

if(file_exists(__PATH_ONLINEPLAYERS_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	// attempt to load same language as website
	if(!@include_once(__PATH_ONLINEPLAYERS_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) throw new Exception('Error loading language file (online players)');
} else {
	// load default language file (en)
	if(!@include_once(__PATH_ONLINEPLAYERS_ROOT__ . 'languages/en/language.php')) throw new Exception('Error loading language file (online players)');
}

// load classes
if(!@include_once(__PATH_ONLINEPLAYERS_ROOT__ . 'classes/class.onlineplayers.php')) throw new Exception(lang('onlineplayers_error_1', true));